﻿################################################################################
## Initialization
################################################################################

init offset = -1

################################################################################
## Styles
################################################################################

style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)



################################################################################
## In-game screens
################################################################################


## Say screen ##################################################################
##
## The say screen is used to display dialogue to the player. It takes two
## parameters, who and what, which are the name of the speaking character and
## the text to be displayed, respectively. (The who parameter can be None if no
## name is given.)
##
## This screen must create a text displayable with id "what", as Ren'Py uses
## this to manage text display. It can also create displayables with id "who"
## and id "window" to apply style properties.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):
    style_prefix "say"

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "namebox"
                text who id "who"

        text what id "what"


    ## If there's a side image, display it above the text. Do not display on the
    ## phone variant - there's no room.
    if not renpy.variant("small"):
        add SideImage() xalign 0.0 yalign 1.0


## Make the namebox available for styling through the Character object.
init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    background Image("gui/textbox2.png", xalign=0.5, yalign=1.0)

style namebox:
    xpos gui.name_xpos
    xanchor gui.name_xalign
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos



## Clicker screen ################################################################
##
## minigame in game

screen clicker:
    modal True
    timer .5 repeat True action [If(points <= 0, true=Jump(cap_number+"clicker_lost"), false=SetVariable("points", points - plus))]

#    text "[points] / [max_point]" size 40:
#        xpos .4
#        ypos .4
    button:
        background Image("gui/pink_heart.png")
        xpos .4
        ypos .6
        xysize(300, 300)
        action [SetVariable("clicked", True) ,If(points >= max_point, true=Jump(cap_number+"clicker_win"), false=SetVariable("points", points + plus))]
    bar value StaticValue(points, max_point)


## Clicker v2 screen ################################################################
##
## minigame in game

screen clickerV2:
    modal True

    if parte == 50:
        $ jump_next =  jump_win

    timer .5 repeat True action [If(points <= 0, true=Jump(jump_lost), false=SetVariable("points", points - plus))]

    if parte < 10:
        $ x=.4
        $ y=.4
    elif parte <20:
        $ x=.7
        $ y=.5
    elif parte <30:
        $ x=.3
        $ y=.2
    elif parte <40:
        $ x=.6
        $ y=.3
    elif parte <50:
        $ x=.3
        $ y=.6
    elif parte <60:
        $ x=.4
        $ y=.4
    elif parte <70:
        $ x=.7
        $ y=.5
    elif parte <80:
        $ x=.3
        $ y=.2
    elif parte <90:
        $ x=.6
        $ y=.3
    elif parte <100:
        $ x=.3
        $ y=.6
    elif parte <110:
        $ x=.3
        $ y=.6
    elif parte <120:
        $ x=.4
        $ y=.4
    elif parte <130:
        $ x=.7
        $ y=.5
    elif parte <140:
        $ x=.3
        $ y=.2
    elif parte <150:
        $ x=.6
        $ y=.3
    elif parte <160:
        $ x=.3
        $ y=.6
    $ parte = parte+1

    button:
        background Image(imagen_juego)
        xpos x
        ypos y
        xysize(300, 300)
        action [SetVariable("clicked", True), If(points >= max_point, true=Jump(jump_next), false=SetVariable("points", points + plus))]
    bar value StaticValue(points, max_point)

## Imposible Clicker v3 screen ################################################################
##
## minigame in game

screen clickerV3:
    modal True

    if parte == 50:
        $ jump_next =  jump_win

    timer .5 repeat True action [If(points <= 0, true=Jump(jump_lost), false=SetVariable("points", points - (plus*6)))]

    if parte < 10:
        $ x=.4
        $ y=.4
    elif parte <20:
        $ x=.7
        $ y=.5
    elif parte <30:
        $ x=.3
        $ y=.2
    elif parte <40:
        $ x=.6
        $ y=.3
    elif parte <50:
        $ x=.3
        $ y=.6
    elif parte < 60:
        $ x=.4
        $ y=.4
    elif parte <70:
        $ x=.7
        $ y=.5
    elif parte <80:
        $ x=.3
        $ y=.2
    elif parte <90:
        $ x=.6
        $ y=.3
    elif parte <100:
        $ x=.3
        $ y=.6
    elif parte <110:
        $ x=.3
        $ y=.6
    elif parte < 120:
        $ x=.4
        $ y=.4
    elif parte <130:
        $ x=.7
        $ y=.5
    elif parte <140:
        $ x=.3
        $ y=.2
    elif parte <150:
        $ x=.6
        $ y=.3
    elif parte <160:
        $ x=.3
        $ y=.6
    $ parte = parte+1

    button:
        background Image(imagen_juego)
        xpos x
        ypos y
        xysize(300, 300)
        action [SetVariable("clicked", True), If(points >= max_point, true=Jump(jump_next), false=SetVariable("points", points + plus))]
    bar value StaticValue(points, max_point)


## Input screen ################################################################
##
## This screen is used to display renpy.input. The prompt parameter is used to
## pass a text prompt in.
##
## This screen must create an input displayable with id "input" to accept the
## various input parameters.
##
## https://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"
    if renpy.variant("pc") or renpy.variant("web"):
        window:
            background Image("gui/textbox.png", xalign=0.5, yalign=1.0)
            vbox:
                xalign gui.dialogue_text_xalign
                xpos gui.dialogue_xpos
                xsize gui.dialogue_width
                ypos gui.dialogue_ypos

                text prompt style "input_prompt"
                input id "input"
    else:
        window:
            background Image("gui/phone/textbox.png", xalign=0.5, yalign=1.0)
            vbox:
                xalign gui.dialogue_text_xalign
                xpos gui.dialogue_xpos
                xsize gui.dialogue_width
                ypos gui.dialogue_ypos

                text prompt style "input_prompt"
                input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")


style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width


## Choice screen ###############################################################
##
## This screen is used to display the in-game choices presented by the menu
## statement. The one parameter, items, is a list of objects, each with caption
## and action fields.
##
## https://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            textbutton i.caption action i.action



##outline text
define gui.name_text_outlines = [ (4, "#ffffff")]
define gui.dialogue_text_outlines = [ (3, "#ffffff")]

## When this is true, menu captions will be spoken by the narrator. When false,
## menu captions will be displayed as empty buttons.
define config.narrator_menu = True


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    ypos 405
    yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")


## Quick Menu screen ###########################################################
##
## The quick menu is displayed in-game to provide easy access to the out-of-game
## menus.

screen quick_menu():

    ## Ensure this appears on top of other screens.
    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Back") action Rollback()
            textbutton _("History") action ShowMenu('history')
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Save") action ShowMenu('save')
            textbutton _("Q.Save") action QuickSave()
            textbutton _("Q.Load") action QuickLoad()
            textbutton _("Prefs") action ShowMenu('preferences')



## This code ensures that the quick_menu screen is displayed in-game, whenever
## the player has not explicitly hidden the interface.
init python:
    config.overlay_screens.append("quick_menu")

default quick_menu = True

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.button_text_properties("quick_button")

################################################################################
## Main and Game Menu Screens
################################################################################

## Navigation screen ###########################################################
##
## This screen is included in the main and game menus, and provides navigation
## to other menus, and to start the game.

screen navigation():

    vbox:
        style_prefix "navigation"

        xpos gui.navigation_xpos
        yalign 0.5

        spacing gui.navigation_spacing

        if main_menu:

            #textbutton _("Start") action Start()
            imagebutton auto "gui/start_%s.png" action Start() hovered Play("sound", "audio/effects/click.mp3")

        else:

            textbutton _("History") action ShowMenu("history")

            textbutton _("Save") action ShowMenu("save")

        if not main_menu:
            textbutton _("Load") action ShowMenu("load")
            textbutton _("Select chapter") action ShowMenu("chapterSel")
            textbutton _("Settings") action ShowMenu("preferences")
            textbutton _("Help") action ShowMenu("help")
        else:
            imagebutton auto "gui/select_c_%s.png" action ShowMenu("chapterSel") hovered Play("sound", "audio/effects/click.mp3")
            imagebutton auto "gui/pref_%s.png"  action ShowMenu("preferences") hovered Play("sound", "audio/effects/click.mp3")
            imagebutton auto "gui/load_%s.png" action ShowMenu("load") hovered Play("sound", "audio/effects/click.mp3")
            imagebutton auto "gui/help_%s.png"  action ShowMenu("help") hovered Play("sound", "audio/effects/click.mp3")

        if _in_replay:

            textbutton _("End Replay") action EndReplay(confirm=True)

        elif not main_menu:

            textbutton _("Main Menu") action MainMenu()

        #textbutton _("About") action ShowMenu("about")

        ##if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):

            ## Help isn't necessary or relevant to mobile devices.



        if renpy.variant("pc"):

            ## The quit button is banned on iOS and unnecessary on Android and
            ## Web.
            if not main_menu:
                textbutton _("Quit") action Quit(confirm=not main_menu)
            else:
                imagebutton auto "gui/quit_%s.png"  action Quit(confirm=not main_menu) hovered Play("sound", "audio/effects/click.mp3")



style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")

transform patreon_button:
    xalign 0.97
    yalign 0.95
    on idle:
        easein 0.05 zoom 0.5
    on hover:
        easein 0.05 zoom 0.6


## Main Menu screen ############################################################
##
## Used to display the main menu when Ren'Py starts.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    ## This ensures that any other menu screen is replaced.
    tag menu

    add gui.main_menu_background

    imagebutton auto "gui/patreon_button_%s.png" action OpenURL("https://www.patreon.com/bolskangames"):

        at patreon_button

    ## This empty frame darkens the main menu.
    frame:
        style "main_menu_frame"

    ## The use statement includes another screen inside this one. The actual
    ## contents of the main menu are in the navigation screen.
    use navigation

    if gui.show_name:

        vbox:
            style "main_menu_vbox"

            #text "[config.name!t]":
            #    style "main_menu_title"

            #text "[config.version]":
            #    style "main_menu_version"


style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 420
    yfill True

    #background "gui/overlay/main_menu.png"

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -30

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_version:
    properties gui.text_properties("version")



## Chapter selection ############################################################
##
## Te lleva directamente al capítulo que tu elijas

screen chapterSel():
    tag menu
    if renpy.variant("pc") or renpy.variant("web"):
        use game_menu(_("Chapter selection")):
            style_prefix "chapterSel"

            viewport id "vp_chapter":
                mousewheel True
                hbox:
                    spacing 40
                    vbox:

                        style_prefix "radio"
                        label _("Jump to")
                        imagebutton auto "gui/chapter/cap1_%s.webp" action Start("cheat_cap1")
                    #     imagebutton auto "gui/chapter/cap4_%s.webp" action Start("cheat_cap4")
                    #    imagebutton auto "gui/chapter/cap7_%s.webp" action Start("cheat_cap7")
                    #     imagebutton auto "gui/chapter/cap10_%s.webp" action Start("cheat_cap10")
                    #     imagebutton auto "gui/chapter/cap13_%s.webp" action Start("cheat_cap13")
                    #     imagebutton auto "gui/chapter/cap16_%s.webp" action Start("cheat_cap16")
                    #     imagebutton auto "gui/chapter/cap19_%s.webp" action Start("cheat_cap19")
                    #     imagebutton auto "gui/chapter/cap22_%s.webp" action Start("cheat_cap22")
                    #     imagebutton auto "gui/chapter/cap25_%s.webp" action Start("cheat_cap25")
                    #     imagebutton auto "gui/chapter/cap28_%s.webp" action Start("cheat_cap28")
                    #     imagebutton auto "gui/chapter/cap31_%s.webp" action Start("cheat_cap31")
                    #     imagebutton auto "gui/chapter/cap34_%s.webp" action Start("cheat_cap34")
                    #     imagebutton auto "gui/chapter/cap37_%s.webp" action Start("cheat_cap37")
                    #     imagebutton auto "gui/chapter/cap40_%s.webp" action Start("cheat_cap40")
                    #     imagebutton auto "gui/chapter/cap43_%s.webp" action Start("cheat_cap43")

                    vbox:
                        style_prefix "radio"
                        label _(" ")
                    #     imagebutton auto "gui/chapter/cap2_%s.webp" action Start("cheat_cap2")
                    #     imagebutton auto "gui/chapter/cap5_%s.webp" action Start("cheat_cap5")
                    #     imagebutton auto "gui/chapter/cap8_%s.webp" action Start("cheat_cap8")
                    #     imagebutton auto "gui/chapter/cap11_%s.webp" action Start("cheat_cap11")
                    #     imagebutton auto "gui/chapter/cap14_%s.webp" action Start("cheat_cap14")
                    #     imagebutton auto "gui/chapter/cap17_%s.webp" action Start("cheat_cap17")
                    #     imagebutton auto "gui/chapter/cap20_%s.webp" action Start("cheat_cap20")
                    # #     imagebutton auto "gui/chapter/cap23_%s.webp" action Start("cheat_cap23")
                    #     imagebutton auto "gui/chapter/cap26_%s.webp" action Start("cheat_cap26")
                    #     imagebutton auto "gui/chapter/cap29_%s.webp" action Start("cheat_cap29")
                    #     imagebutton auto "gui/chapter/cap32_%s.webp" action Start("cheat_cap32")
                    #     imagebutton auto "gui/chapter/cap35_%s.webp" action Start("cheat_cap35")
                    #     imagebutton auto "gui/chapter/cap38_%s.webp" action Start("cheat_cap38")
                    #     imagebutton auto "gui/chapter/cap41_%s.webp" action Start("cheat_cap41")
                    #     imagebutton auto "gui/chapter/cap44_%s.webp" action Start("cheat_cap44")

                    vbox:
                        style_prefix "radio"
                        label _(" ")
                    #     imagebutton auto "gui/chapter/cap3_%s.webp" action Start("cheat_cap3")
                    #     imagebutton auto "gui/chapter/cap6_%s.webp" action Start("cheat_cap6")
                    #     imagebutton auto "gui/chapter/cap9_%s.webp" action Start("cheat_cap9")
                    #     imagebutton auto "gui/chapter/cap12_%s.webp" action Start("cheat_cap12")
                    #     imagebutton auto "gui/chapter/cap15_%s.webp" action Start("cheat_cap15")
                    #     imagebutton auto "gui/chapter/cap18_%s.webp" action Start("cheat_cap18")
                    #     imagebutton auto "gui/chapter/cap21_%s.webp" action Start("cheat_cap21")
                    #     imagebutton auto "gui/chapter/cap24_%s.webp" action Start("cheat_cap24")
                    #     imagebutton auto "gui/chapter/cap27_%s.webp" action Start("cheat_cap27")
                    #     imagebutton auto "gui/chapter/cap30_%s.webp" action Start("cheat_cap30")
                    #     imagebutton auto "gui/chapter/cap33_%s.webp" action Start("cheat_cap33")
                    #     imagebutton auto "gui/chapter/cap36_%s.webp" action Start("cheat_cap36")
                    #     imagebutton auto "gui/chapter/cap39_%s.webp" action Start("cheat_cap39")
                    #     imagebutton auto "gui/chapter/cap42_%s.webp" action Start("cheat_cap42")
                    #     imagebutton auto "gui/chapter/cap42_%s.webp" action Start("cheat_cap45")


            vbar value YScrollValue("vp_chapter") xpos 1.0
    else:
        use game_menu(_("Chapter selection"), scroll="hbox"):
            style_prefix "chapterSel"

            viewport id "vp_chapter2":
                draggable True
                hbox:
                    spacing -200
                    vbox:

                        style_prefix "radio"
                        label _("Jump to")
                        imagebutton auto "gui/chapter/cap1_%s.webp" action Start("cheat_cap1")
                    #     imagebutton auto "gui/chapter/cap4_%s.webp" action Start("cheat_cap4")
                    #     imagebutton auto "gui/chapter/cap7_%s.webp" action Start("cheat_cap7")
                    #     imagebutton auto "gui/chapter/cap10_%s.webp" action Start("cheat_cap10")
                    #     imagebutton auto "gui/chapter/cap13_%s.webp" action Start("cheat_cap13")
                    ##      imagebutton auto "gui/chapter/cap16_%s.webp" action Start("cheat_cap16")
                    #     imagebutton auto "gui/chapter/cap19_%s.webp" action Start("cheat_cap19")
                    #     imagebutton auto "gui/chapter/cap22_%s.webp" action Start("cheat_cap22")
                    #     imagebutton auto "gui/chapter/cap25_%s.webp" action Start("cheat_cap25")
                    #     imagebutton auto "gui/chapter/cap28_%s.webp" action Start("cheat_cap28")
                    #     imagebutton auto "gui/chapter/cap31_%s.webp" action Start("cheat_cap31")
                    #     imagebutton auto "gui/chapter/cap34_%s.webp" action Start("cheat_cap34")
                    #     imagebutton auto "gui/chapter/cap37_%s.webp" action Start("cheat_cap37")
                    #     imagebutton auto "gui/chapter/cap40_%s.webp" action Start("cheat_cap40")
                    #     imagebutton auto "gui/chapter/cap43_%s.webp" action Start("cheat_cap43")

                    vbox:
                        style_prefix "radio"
                        label _(" ")
                    #     imagebutton auto "gui/chapter/cap2_%s.webp" action Start("cheat_cap2")
                    #     imagebutton auto "gui/chapter/cap5_%s.webp" action Start("cheat_cap5")
                    #     imagebutton auto "gui/chapter/cap8_%s.webp" action Start("cheat_cap8")
                    #     imagebutton auto "gui/chapter/cap11_%s.webp" action Start("cheat_cap11")
                    #     imagebutton auto "gui/chapter/cap14_%s.webp" action Start("cheat_cap14")
                    #     imagebutton auto "gui/chapter/cap17_%s.webp" action Start("cheat_cap17")
                    #     imagebutton auto "gui/chapter/cap20_%s.webp" action Start("cheat_cap20")
                    #     imagebutton auto "gui/chapter/cap23_%s.webp" action Start("cheat_cap23")
                    #     imagebutton auto "gui/chapter/cap26_%s.webp" action Start("cheat_cap26")
                    #     imagebutton auto "gui/chapter/cap29_%s.webp" action Start("cheat_cap29")
                    #     imagebutton auto "gui/chapter/cap32_%s.webp" action Start("cheat_cap32")
                    #     imagebutton auto "gui/chapter/cap35_%s.webp" action Start("cheat_cap35")
                    #     imagebutton auto "gui/chapter/cap38_%s.webp" action Start("cheat_cap38")
                    #     imagebutton auto "gui/chapter/cap41_%s.webp" action Start("cheat_cap41")
                    #     imagebutton auto "gui/chapter/cap44_%s.webp" action Start("cheat_cap44")

                    vbox:
                        style_prefix "radio"
                        label _(" ")
                    #     imagebutton auto "gui/chapter/cap3_%s.webp" action Start("cheat_cap3")
                    #     imagebutton auto "gui/chapter/cap6_%s.webp" action Start("cheat_cap6")
                    #     imagebutton auto "gui/chapter/cap9_%s.webp" action Start("cheat_cap9")
                    #     imagebutton auto "gui/chapter/cap12_%s.webp" action Start("cheat_cap12")
                    #     imagebutton auto "gui/chapter/cap15_%s.webp" action Start("cheat_cap15")
                    #     imagebutton auto "gui/chapter/cap18_%s.webp" action Start("cheat_cap18")
                    #     imagebutton auto "gui/chapter/cap21_%s.webp" action Start("cheat_cap21")
                    #     imagebutton auto "gui/chapter/cap24_%s.webp" action Start("cheat_cap24")
                    #     imagebutton auto "gui/chapter/cap27_%s.webp" action Start("cheat_cap27")
                    #     imagebutton auto "gui/chapter/cap30_%s.webp" action Start("cheat_cap30")
                    #     imagebutton auto "gui/chapter/cap33_%s.webp" action Start("cheat_cap33")
                    #     imagebutton auto "gui/chapter/cap36_%s.webp" action Start("cheat_cap36")
                    #     imagebutton auto "gui/chapter/cap39_%s.webp" action Start("cheat_cap39")
                    #     imagebutton auto "gui/chapter/cap42_%s.webp" action Start("cheat_cap42")
                    #     imagebutton auto "gui/chapter/cap42_%s.webp" action Start("cheat_cap45")

            vbar value YScrollValue("vp_chapter2") xpos 1.0

label enterBoyName:
    with Dissolve(.5)
    scene intro_bg
    with Dissolve(.5)

    python:
        mcs = renpy.input("Please enter the name of your character")
        if mcs=="":
            mcs="John"
        mc = Character("[mcs]", color="#283578", what_color="#34469e")

    return

label enterGirlName:
    python:
        mcsf = renpy.input("Please, now enter a girl name for your character")
        if mcsf=="":
            mcsf="Abby"

        mcf = Character("[mcsf]", color="#283578", what_color="#34469e")
    return

label cheat_cap1:
    call enterBoyName from _call_enterBoyName
    jump cap1

label cheat_cap2:
    call enterBoyName from _call_enterBoyName_1

    scene intro_bg_154

    menu:
        "Did you choose to deny your last orgasm?"
        "Yes":
            $ cap1_denial = True
        "No":
            $ cap1_denial = False

    jump cap2

label cheat_cap3:
    call enterBoyName from _call_enterBoyName_2

    scene cap2_bg_272

    menu:
        "Break contract with Aiko?"
        "Yes":
            $ cap2_rompe = True
        "No":
            $ cap2_rompe = False

    jump cap3

label cheat_cap4:
    call enterBoyName from _call_enterBoyName_3
    jump cap4

label cheat_cap5:
    call enterBoyName from _call_enterBoyName_4

    scene cap4_bg_98

    menu:
        "Did you obey and wore the panties?"
        "Yes":
            $ obey_panties = True
        "No":
            $ obey_panties = False

    jump cap5

label cheat_cap6:
    call enterBoyName from _call_enterBoyName_5

    scene cap5_bg_108

    menu:
        ai "Which dress did you choose?"
        "Maid dress":
            $ dress_cap5 = 1
        "Street dress":
            $ dress_cap5 = 2
        "Slutty dress":
            $ dress_cap5 = 3

    jump cap6

label cheat_cap7:
    call enterBoyName from _call_enterBoyName_6

    jump cap7

label cheat_cap8:
    call enterBoyName from _call_enterBoyName_7
    call enterGirlName from _call_enterGirlName

    jump cap8

label cheat_cap9:
    call enterBoyName from _call_enterBoyName_8
    call enterGirlName from _call_enterGirlName_1

    jump cap9

label cheat_cap10:
    call enterBoyName from _call_enterBoyName_9
    call enterGirlName from _call_enterGirlName_2

    jump cap10

label cheat_cap11:
    call enterBoyName from _call_enterBoyName_10
    call enterGirlName from _call_enterGirlName_3

    jump cap11

label cheat_cap12:
    call enterBoyName from _call_enterBoyName_11
    call enterGirlName from _call_enterGirlName_4

    jump cap12

label cheat_cap13:
    call enterBoyName from _call_enterBoyName_12
    call enterGirlName from _call_enterGirlName_5

    jump cap13

label cheat_cap14:
    call enterBoyName from _call_enterBoyName_13
    call enterGirlName from _call_enterGirlName_6

    scene cap13_bg_4

    menu:
        n "Who are you accusing of sabotaging Saya's cafe?"
        "Accuse Aiko":
            $ cap13_accuseAiko= True
            $ cap13_accuseAzami = False
            $ cap13_NoAccuse = False
        "Accuse Azami":
            $ cap13_accuseAiko= False
            $ cap13_accuseAzami = True
            $ cap13_NoAccuse = False
        "Say nothing":
            $ cap13_accuseAiko= False
            $ cap13_accuseAzami = False
            $ cap13_NoAccuse = True

    play music "audio/music/sexy_music.mp3" fadein 1.0
    jump cap14

label cheat_cap15:
    call enterBoyName from _call_enterBoyName_14
    call enterGirlName from _call_enterGirlName_7
    play music "audio/music/main_music.mp3" fadein 1.0

    jump cap15

label cheat_cap16:
    call enterBoyName from _call_enterBoyName_15
    call enterGirlName from _call_enterGirlName_8
    scene cap16_bg_1 with Dissolve(.3)
    play music "audio/music/sexy_music2.mp3" fadein 1.0

    jump cap16

label cheat_cap17:
    call enterBoyName from _call_enterBoyName_16
    call enterGirlName from _call_enterGirlName_9
    play music "audio/music/sexy_music4.mp3" fadein 1.0

    jump cap17

label cheat_cap18:
    call enterBoyName from _call_enterBoyName_17
    call enterGirlName from _call_enterGirlName_10
    play music "audio/music/main_music.mp3"  fadein 1.0

    jump cap18

label cheat_cap19:
    call enterBoyName from _call_enterBoyName_18
    call enterGirlName from _call_enterGirlName_11

    jump cap19

label cheat_cap20:
    call enterBoyName from _call_enterBoyName_19
    call enterGirlName from _call_enterGirlName_12
    play music "audio/music/main_music.mp3"  fadein 1.0

    jump cap20

label cheat_cap21:
    call enterBoyName from _call_enterBoyName_20
    call enterGirlName from _call_enterGirlName_13
    play music "audio/music/main_music.mp3"  fadein 1.0

    scene cap20_bg_193

    menu:
        "Skip the first room? (Sexual frustration & denial)"
        "Yes":
            $ cap21_room1Visited = True
            $ cap21_contSalas = 1
        "No":
            $ cap21_room1Visited = False
            $ cap21_contSalas = 0


    jump cap21

label cheat_cap22:
    call enterBoyName from _call_enterBoyName_21
    call enterGirlName from _call_enterGirlName_14
    play music "audio/music/suspense.mp3"  fadein 1.0
    $ cap22_findMarin = True
    $ cap22_barSissy = False
    $ cap22_danceGirls = False
    $ cap22_walkDanceFloor = False
    $ cap23_plugSuki = False
    $ cap22_contPlaces = 0

    jump cap22

label cheat_cap23:
    call enterBoyName from _call_enterBoyName_22
    call enterGirlName from _call_enterGirlName_15
    play music "audio/music/club_music.mp3"  fadein 1.0
    play mc "audio/effects/crowd.mp3"  fadein 2.0 loop

    scene cap22_bg_196
    $ cap22_danceGirls = False
    $ cap22_walkDanceFloor = False
    $ cap23_plugSuki = False

    menu:
        "Skip approach to the club bar and Marin scene?"
        "Yes":
            $ cap22_barSissy = True
            $ cap22_findMarin = True
            $ cap22_contPlaces = 2
        "No":
            $ cap22_barSissy = False
            $ cap22_contPlaces = 0


    jump cap22_elec

label cheat_cap24:
    call enterBoyName from _call_enterBoyName_23
    call enterGirlName from _call_enterGirlName_16
    play music "audio/music/club_music.mp3"  fadein 1.0
    play mc "audio/effects/crowd.mp3"  fadein 2.0 loop

    jump cap24

label cheat_cap25:
    call enterBoyName from _call_enterBoyName_24
    call enterGirlName from _call_enterGirlName_17
    play music "audio/music/main_music.mp3"  fadein 1.0

    jump cap25

label cheat_cap26:
    call enterBoyName from _call_enterBoyName_25
    call enterGirlName from _call_enterGirlName_18
    play music "audio/music/sexy_music.mp3"  fadein 1.0

    jump cap26

label cheat_cap27:
    call enterBoyName from _call_enterBoyName_26
    call enterGirlName from _call_enterGirlName_19
    play music "audio/music/main_music2.mp3"  fadein 1.0

    jump cap27

label cheat_cap28:
    call enterBoyName from _call_enterBoyName_27
    call enterGirlName from _call_enterGirlName_20

    jump cap28

label cheat_cap29:
    call enterBoyName from _call_enterBoyName_28
    call enterGirlName from _call_enterGirlName_21
    play music "audio/music/suspense.mp3"  fadein 1.0

    jump cap29

label cheat_cap30:
    call enterBoyName from _call_enterBoyName_29
    call enterGirlName from _call_enterGirlName_22
    stop music fadeout 2.0

    jump cap30

label cheat_cap31:
    call enterBoyName from _call_enterBoyName_30
    call enterGirlName from _call_enterGirlName_23

    scene cap30_bg_117 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapter?"

            "Left":
                $ cap30_outfit = 1

            "Center":
                $ cap30_outfit = 2

            "Right":
                $ cap30_outfit = 3


    play music "audio/music/sexy_music.mp3"  fadein 1.0

    jump cap31

label cheat_cap32:
    call enterBoyName from _call_enterBoyName_31
    call enterGirlName from _call_enterGirlName_24

    scene cap30_bg_117 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapter?"

            "Left":
                $ cap30_outfit = 1

            "Center":
                $ cap30_outfit = 2

            "Right":
                $ cap30_outfit = 3


    play music "audio/music/main_music.mp3"  fadein 1.0

    jump cap32

label cheat_cap33:
    $ cap33_under = False
    $ cap33_clothes = False
    $ cap35_toysStore = False
    $ cap37_toiletPic = False
    call enterBoyName from _call_enterBoyName_32
    call enterGirlName from _call_enterGirlName_25
    stop music fadeout 2.0
    play music "audio/music/main_music.mp3"  fadein 1.0
    play ambient2 "audio/effects/city.mp3" loop fadein 1.0

    jump cap33

label cheat_cap34:
    call enterBoyName from _call_enterBoyName_33
    call enterGirlName from _call_enterGirlName_26
    $ cap33_under = True
    $ cap33_clothes = True
    $ cap35_toysStore = False
    $ cap37_toiletPic = False
    scene cap34_bg_87 with Dissolve(.3)
    scene cap33_bg_121 with Dissolve(.3)
    menu:
            n "What underwear did you choose in the previous chapters?"

            "Left":
                $ cap33_underwear = 1

            "Center":
                $ cap33_underwear = 2

            "Right":
                $ cap33_underwear = 3

    scene cap33_bg_210 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapters?"

            "Left":
                $ cap33_outfit = 1

            "Center":
                $ cap33_outfit = 2

            "Right":
                $ cap33_outfit = 3
    stop music fadeout 2.0
    play music "audio/music/main_music.mp3"  fadein 1.0
    play ambient "audio/effects/cafe_ambient.mp3" loop fadein 1.0

    jump cap34

label cheat_cap35:
    stop music fadeout 2.0
    call enterBoyName from _call_enterBoyName_34
    call enterGirlName from _call_enterGirlName_27
    $ cap33_under = True
    $ cap33_clothes = True
    $ cap35_toysStore = False
    $ cap37_toiletPic = False

    scene cap33_bg_121 with Dissolve(.3)
    menu:
            n "What underwear did you choose in the previous chapters?"

            "Left":
                $ cap33_underwear = 1

            "Center":
                $ cap33_underwear = 2

            "Right":
                $ cap33_underwear = 3

    scene cap33_bg_210 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapters?"

            "Left":
                $ cap33_outfit = 1

            "Center":
                $ cap33_outfit = 2

            "Right":
                $ cap33_outfit = 3

    scene cap34_bg_87 with Dissolve(.3)
    menu:
            n "Did you serve all the customers correctly at the maid café?"

            "Yes, I did":
                $ cap35_waitressJob = True

            "No, I didn't":
                $ cap35_waitressJob = False


    jump cap35

label cheat_cap36:

    stop music fadeout 2.0

    $ cap33_under = True
    $ cap33_clothes = True
    $ cap35_toysStore = True
    $ cap37_toiletPic = False
    call enterBoyName from _call_enterBoyName_35
    call enterGirlName from _call_enterGirlName_28
    scene cap33_bg_121 with Dissolve(.3)
    menu:
            n "What underwear did you choose in the previous chapters?"

            "Left":
                $ cap33_underwear = 1

            "Center":
                $ cap33_underwear = 2

            "Right":
                $ cap33_underwear = 3

    scene cap33_bg_210 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapters?"

            "Left":
                $ cap33_outfit = 1

            "Center":
                $ cap33_outfit = 2

            "Right":
                $ cap33_outfit = 3
    play music "audio/music/sexy_music2.mp3" fadein 1.0

    jump cap36

label cheat_cap37:

    stop music fadeout 2.0

    $ cap33_under = True
    $ cap33_clothes = True
    $ cap35_toysStore = True
    $ cap37_toiletPic = True
    call enterBoyName from _call_enterBoyName_36
    call enterGirlName from _call_enterGirlName_29
    scene cap33_bg_121 with Dissolve(.3)
    menu:
            n "What underwear did you choose in the previous chapters?"

            "Left":
                $ cap33_underwear = 1

            "Center":
                $ cap33_underwear = 2

            "Right":
                $ cap33_underwear = 3

    scene cap33_bg_210 with Dissolve(.3)
    menu:
            n "What outfit did you choose in the previous chapters?"

            "Left":
                $ cap33_outfit = 1

            "Center":
                $ cap33_outfit = 2

            "Right":
                $ cap33_outfit = 3


    play music "audio/music/main_music.mp3" fadein 1.0

    jump cap37_chapterS

label cheat_cap38:

    call enterBoyName from _call_enterBoyName_37
    call enterGirlName from _call_enterGirlName_30
    stop music fadeout 2.0

    jump cap38

label cheat_cap39:

    call enterBoyName from _call_enterBoyName_38
    call enterGirlName from _call_enterGirlName_31
    stop music fadeout 2.0

    jump cap39

label cheat_cap40:

    call enterBoyName from _call_enterBoyName_39
    call enterGirlName from _call_enterGirlName_32
    scene ca39_bg_90 with Dissolve(.6)
    menu:
        n "Who did you decide to spend the day with in the previous chapter?"

        "Aiko":
            $ cap39_chooseAiko = 1
        "Azami":
            $ cap39_chooseAiko = 0

    stop music fadeout 2.0
    play music "audio/music/sexy_music.mp3" fadein 1.0
    stop aiko fadeout 1.0
    stop sound fadeout 1.0

    jump cap40

label cheat_cap41:

    call enterBoyName from _call_enterBoyName_40
    call enterGirlName from _call_enterGirlName_33
    stop music fadeout 2.0
    play music "audio/music/suspense.mp3" fadein 1.0
    stop aiko fadeout 1.0
    stop sound fadeout 1.0

    jump cap41

label cheat_cap42:

    call enterBoyName from _call_enterBoyName_41
    call enterGirlName from _call_enterGirlName_34
    stop music fadeout 2.0
    stop aiko fadeout 1.0
    stop sound fadeout 1.0

    play music "audio/music/sexy_music2.mp3" fadein 1.0
    jump cap42


label cheat_cap43:

    call enterBoyName from _call_enterBoyName_42
    call enterGirlName from _call_enterGirlName_35
    stop music fadeout 2.0
    stop sound fadeout 1.0
    stop aiko fadeout 1.0

    scene cap42_bg_47 with Dissolve(.6)
    menu:
        n "Who did you decide to help in the locker room in the previous chapter?"

        "Aiko":
            $ cap42_chooseAiko = 1
        "Azami":
            $ cap42_chooseAiko = 0


    play music "audio/music/sexy_music4.mp3" fadein 1.0
    play ambient "audio/effects/orgy.mp3" loop fadein 1.0
    jump cap43

label cheat_cap44:

    call enterBoyName from _call_enterBoyName_43
    call enterGirlName from _call_enterGirlName_36
    stop music fadeout 2.0
    stop sound fadeout 1.0
    stop aiko fadeout 1.0

    play music "audio/music/main_music2.mp3" fadein 1.0
    jump cap44

label cheat_cap45:

    call enterBoyName from _call_enterBoyName_44
    call enterGirlName from _call_enterGirlName_37
    stop music fadeout 2.0
    stop sound fadeout 1.0
    stop aiko fadeout 1.0

    #play music "audio/music/main_music2.mp3" fadein 1.0
    jump cap45


## Game Menu screen ############################################################
##
## This lays out the basic common structure of a game menu screen. It's called
## with the screen title, and displays the background, title, and navigation.
##
## The scroll parameter can be None, or one of "viewport" or "vpgrid". When
## this screen is intended to be used with one or more children, which are
## transcluded (placed) inside it.

screen game_menu(title, scroll=None, yinitial=0.0):

    style_prefix "game_menu"

    if main_menu:
        add gui.main_menu_background
    else:
        add gui.game_menu_background

    frame:
        style "game_menu_outer_frame"

        hbox:

            ## Reserve space for the navigation section.
            frame:
                style "game_menu_navigation_frame"

            frame:
                style "game_menu_content_frame"

                if scroll == "viewport":

                    viewport:
                        yinitial yinitial
                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        vbox:
                            transclude

                elif scroll == "vpgrid":

                    vpgrid:
                        cols 1
                        yinitial yinitial

                        scrollbars "vertical"
                        mousewheel True
                        draggable True
                        pagekeys True

                        side_yfill True

                        transclude

                else:

                    transclude

    use navigation

    textbutton _("Return"):
        style "return_button"

        action Return()

    label title

    if main_menu:
        key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 45
    top_padding 180

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 420
    yfill True

style game_menu_content_frame:
    left_margin 60
    right_margin 30
    top_margin 15

style game_menu_viewport:
    xsize 1380

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 15

style game_menu_label:
    xpos 75
    ysize 180

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -45


## About screen ################################################################
##
## This screen gives credit and copyright information about the game and Ren'Py.
##
## There's nothing special about this screen, and hence it also serves as an
## example of how to make a custom screen.

screen about():

    tag menu

    ## This use statement includes the game_menu screen inside this one. The
    ## vbox child is then included inside the viewport inside the game_menu
    ## screen.
    use game_menu(_("About"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]"
            text _("Version [config.version!t]\n")

            ## gui.about is usually set in options.rpy.
            if gui.about:
                text "[gui.about!t]\n"

            text _("Made by BolskanLewdGames.\n{a=https://www.patreon.com/bolskangames}Bolskan's Patreon{/a}")


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size


## Load and Save screens #######################################################
##
## These screens are responsible for letting the player save the game and load
## it again. Since they share nearly everything in common, both are implemented
## in terms of a third screen, file_slots.
##
## https://www.renpy.org/doc/html/screen_special.html#save https://
## www.renpy.org/doc/html/screen_special.html#load

screen save():

    tag menu

    use file_slots(_("Save"))


screen load():

    tag menu

    use file_slots(_("Load"))


screen file_slots(title):

    default page_name_value = FilePageNameInputValue(pattern=_("Page {}"), auto=_("Automatic saves"), quick=_("Quick saves"))

    use game_menu(title):

        fixed:

            ## This ensures the input will get the enter event before any of the
            ## buttons do.
            order_reverse True

            ## The page name, which can be edited by clicking on a button.
            button:
                style "page_label"

                key_events True
                xalign 0.5
                action page_name_value.Toggle()

                input:
                    style "page_label_text"
                    value page_name_value

            ## The grid of file slots.
            grid gui.file_slot_cols gui.file_slot_rows:
                style_prefix "slot"

                xalign 0.5
                yalign 0.5

                spacing gui.slot_spacing

                for i in range(gui.file_slot_cols * gui.file_slot_rows):

                    $ slot = i + 1

                    button:
                        action FileAction(slot)

                        has vbox

                        add FileScreenshot(slot) xalign 0.5

                        text FileTime(slot, format=_("{#file_time}%A, %B %d %Y, %H:%M"), empty=_("empty slot")):
                            style "slot_time_text"

                        text FileSaveName(slot):
                            style "slot_name_text"

                        key "save_delete" action FileDelete(slot)

            ## Buttons to access other pages.
            hbox:
                style_prefix "page"

                xalign 0.5
                yalign 1.0

                spacing gui.page_spacing

                textbutton _("<") action FilePagePrevious()

                if config.has_autosave:
                    textbutton _("{#auto_page}A") action FilePage("auto")

                if config.has_quicksave:
                    textbutton _("{#quick_page}Q") action FilePage("quick")

                ## range(1, 10) gives the numbers from 1 to 9.
                for page in range(1, 10):
                    textbutton "[page]" action FilePage(page)

                textbutton _(">") action FilePageNext()


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 75
    ypadding 5

style page_label_text:
    text_align 0.5
    layout "subtitle"
    hover_color gui.hover_color

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.button_text_properties("page_button")

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.button_text_properties("slot_button")


## Preferences screen ##########################################################
##
## The preferences screen allows the player to configure the game to better suit
## themselves.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences

screen preferences():

    tag menu

    use game_menu(_("Preferences"), scroll="viewport"):

        vbox:

            hbox:
                box_wrap True

                if renpy.variant("pc") or renpy.variant("web"):

                    vbox:
                        style_prefix "radio"
                        label _("Display")
                        textbutton _("Window") action Preference("display", "window")
                        textbutton _("Fullscreen") action Preference("display", "fullscreen")

                vbox:
                    style_prefix "radio"
                    label _("Rollback Side")
                    textbutton _("Disable") action Preference("rollback side", "disable")
                    textbutton _("Left") action Preference("rollback side", "left")
                    textbutton _("Right") action Preference("rollback side", "right")

                vbox:
                    style_prefix "check"
                    label _("Skip")
                    textbutton _("Unseen Text") action Preference("skip", "toggle")
                    textbutton _("After Choices") action Preference("after choices", "toggle")
                    textbutton _("Transitions") action InvertSelected(Preference("transitions", "toggle"))

            ##     vbox:
                ##     style_prefix "cambiarNombre"
                ##     label _("Change names")
                ##     textbutton _("Boy name") action Start("ChangeBoyName")
                ##     textbutton _("Girl / sissy name") action Start("ChangeGirlName")


                ## Additional vboxes of type "radio_pref" or "check_pref" can be
                ## added here, to add additional creator-defined preferences.

            null height (4 * gui.pref_spacing)

            hbox:
                style_prefix "slider"
                box_wrap True

                vbox:

                    label _("Text Speed")

                    bar value Preference("text speed")

                    label _("Auto-Forward Time")

                    bar value Preference("auto-forward time")

                vbox:

                    if config.has_music:
                        label _("Music Volume")

                        hbox:
                            bar value Preference("music volume")

                    if config.has_sound:

                        label _("Sound Volume")

                        hbox:
                            bar value Preference("sound volume")

                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound)


                    if config.has_voice:
                        label _("Voice Volume")

                        hbox:
                            bar value Preference("voice volume")

                            if config.sample_voice:
                                textbutton _("Test") action Play("voice", config.sample_voice)

                    if config.has_music or config.has_sound or config.has_voice:
                        null height gui.pref_spacing

                        textbutton _("Mute All"):
                            action Preference("all mute", "toggle")
                            style "mute_all_button"


label ChangeBoyName:

    python:
        mcs = renpy.input("Please enter the name of your character")
        if mcs=="":
            mcs="John"
        mc = Character("[mcs]", color="#283578", what_color="#34469e")

    return

label ChangeGirlName:

    python:
        mcsf = renpy.input("Please, now enter a girl name for your character")
        if mcsf=="":
            mcsf="Abby"
        mcf = Character("[mcsf]", color="#283578", what_color="#34469e")
    return

style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 3

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 338

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/radio_[prefix_]foreground.png"

style radio_button_text:
    properties gui.button_text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.button_text_properties("check_button")

style slider_slider:
    xsize 525

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 15

style slider_button_text:
    properties gui.button_text_properties("slider_button")

style slider_vbox:
    xsize 675


## History screen ##############################################################
##
## This is a screen that displays the dialogue history to the player. While
## there isn't anything special about this screen, it does have to access the
## dialogue history stored in _history_list.
##
## https://www.renpy.org/doc/html/history.html

screen history():

    tag menu

    ## Avoid predicting this screen, as it can be very large.
    predict False

    use game_menu(_("History"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0):

        style_prefix "history"

        for h in _history_list:

            window:

                ## This lays things out properly if history_height is None.
                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"
                        substitute False

                        ## Take the color of the who text from the Character, if
                        ## set.
                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what:
                    substitute False

        if not _history_list:
            label _("The dialogue history is empty.")


## This determines what tags are allowed to be displayed on the history screen.

define gui.history_allow_tags = { "alt", "noalt" }


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    text_align gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    text_align gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5


## Help screen #################################################################
##
## A screen that gives information about key and mouse bindings. It uses other
## screens (keyboard_help, mouse_help, and gamepad_help) to display the actual
## help.

screen help():

    tag menu

    default device = "keyboard"

    use game_menu(_("Help"), scroll="viewport"):

        style_prefix "help"

        vbox:
            spacing 23

            hbox:

                if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):
                    textbutton _("Keyboard") action SetScreenVariable("device", "keyboard")
                    textbutton _("Mouse") action SetScreenVariable("device", "mouse")
                else:
                    textbutton _("Touch Screen") action SetScreenVariable("device", "touch")
                    $device = "touch"

                if GamepadExists():
                    textbutton _("Gamepad") action SetScreenVariable("device", "gamepad")

            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "touch":
                use touch_help
            elif device == "gamepad":
                use gamepad_help


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Space")
        text _("Advances dialogue without selecting choices.")

    hbox:
        label _("Arrow Keys")
        text _("Navigate the interface.")

    hbox:
        label _("Escape")
        text _("Accesses the game menu.")

    hbox:
        label _("Ctrl")
        text _("Skips dialogue while held down.")

    hbox:
        label _("Tab")
        text _("Toggles dialogue skipping.")

    hbox:
        label _("Page Up")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Page Down")
        text _("Rolls forward to later dialogue.")

    hbox:
        label "H"
        text _("Hides the user interface.")

    hbox:
        label "S"
        text _("Takes a screenshot.")

    hbox:
        label "V"
        text _("Toggles assistive {a=https://www.renpy.org/l/voicing}self-voicing{/a}.")

    hbox:
        label "Shift+A"
        text _("Opens the accessibility menu.")


screen mouse_help():

    hbox:
        label _("Left Click")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Middle Click")
        text _("Hides the user interface.")

    hbox:
        label _("Right Click")
        text _("Accesses the game menu.")

    hbox:
        label _("Mouse Wheel Up\nClick Rollback Side")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Mouse Wheel Down")
        text _("Rolls forward to later dialogue.")

screen touch_help():

    hbox:
        label _("Swipe up")
        text _("Shows de game menu.")

    hbox:
        label _("Swipe down")
        text _("Hides the user interface.")


screen gamepad_help():

    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Left Trigger\nLeft Shoulder")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Right Shoulder")
        text _("Rolls forward to later dialogue.")


    hbox:
        label _("D-Pad, Sticks")
        text _("Navigate the interface.")

    hbox:
        label _("Start, Guide")
        text _("Accesses the game menu.")

    hbox:
        label _("Y/Top Button")
        text _("Hides the user interface.")

    textbutton _("Calibrate") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 12

style help_button_text:
    properties gui.button_text_properties("help_button")

style help_label:
    xsize 375
    right_padding 30

style help_label_text:
    size gui.text_size
    xalign 1.0
    text_align 1.0



################################################################################
## Additional screens
################################################################################


## Confirm screen ##############################################################
##
## The confirm screen is called when Ren'Py wants to ask the player a yes or no
## question.
##
## https://www.renpy.org/doc/html/screen_special.html#confirm

screen confirm(message, yes_action, no_action):

    ## Ensure other screens do not get input while this screen is displayed.
    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"

    frame:

        vbox:
            xalign .5
            yalign .5
            spacing 45

            label _(message):
                style "confirm_prompt"
                xalign 0.5

            hbox:
                xalign 0.5
                spacing 150

                textbutton _("Yes") action yes_action
                textbutton _("No") action no_action

    ## Right-click and escape answer "no".
    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    text_align 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.button_text_properties("confirm_button")


## Skip indicator screen #######################################################
##
## The skip_indicator screen is displayed to indicate that skipping is in
## progress.
##
## https://www.renpy.org/doc/html/screen_special.html#skip-indicator

screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        hbox:
            spacing 9

            text _("Skipping")

            text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.2, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.4, 1.0) style "skip_triangle"


## This transform is used to blink the arrows one after another.
transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:
    ## We have to use a font that has the BLACK RIGHT-POINTING SMALL TRIANGLE
    ## glyph in it.
    font "DejaVuSans.ttf"


## Notify screen ###############################################################
##
## The notify screen is used to show the player a message. (For example, when
## the game is quicksaved or a screenshot has been taken.)
##
## https://www.renpy.org/doc/html/screen_special.html#notify-screen

screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text "[message!tq]"

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    properties gui.text_properties("notify")


## NVL screen ##################################################################
##
## This screen is used for NVL-mode dialogue and menus.
##
## https://www.renpy.org/doc/html/screen_special.html#nvl


screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing

        ## Displays dialogue in either a vpgrid or the vbox.
        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)

        ## Displays the menu, if given. The menu may be displayed incorrectly if
        ## config.narrator_menu is set to True, as it is above.
        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            fixed:
                yfit gui.nvl_height is None

                if d.who is not None:

                    text d.who:
                        id d.who_id

                text d.what:
                    id d.what_id


## This controls the maximum number of NVL-mode entries that can be displayed at
## once.
define config.nvl_list_length = gui.nvl_list_length

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")



################################################################################
## Mobile Variants
################################################################################

style pref_vbox:
    variant "medium"
    xsize 675

## Since a mouse may not be present, we replace the quick menu with a version
## that uses fewer and bigger buttons that are easier to touch.
screen quick_menu():
    variant "touch"

    zorder 100

    if quick_menu:

        hbox:
            style_prefix "quick"

            xalign 0.5
            yalign 1.0

            textbutton _("Back") action Rollback()
            textbutton _("Skip") action Skip() alternate Skip(fast=True, confirm=True)
            textbutton _("Auto") action Preference("auto-forward", "toggle")
            textbutton _("Menu") action ShowMenu()


style window:
    variant "small"
    background "gui/phone/textbox.png"

style radio_button:
    variant "small"
    foreground "gui/phone/button/radio_[prefix_]foreground.png"

style check_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
#    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
#    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 510

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 600

style bar:
    variant "small"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "small"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "small"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "small"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "small"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "small"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_vbox:
    variant "small"
    xsize None

style slider_slider:
    variant "small"
    xsize 900
